/* cgitest.c -- Test of cgi qargs functions

	Copyright 1994,2003,2004,2005,2006
		by Mark E. Mallett, MV Communications, Inc.

	See the "LICENSE" file for terms.

You must either run this under an Apache web server, or set up some
environment variables to simulate the preparation that Apache web
server provides.  For example, in csh terms:

setenv	REQUEST_METHOD	GET
setenv	QUERY_STRING	"name=Mark_E._Mallett&addr-1=blah&email=mem@mv.mv.com"
setenv	CONTENT_LENGTH	52
setenv	DOCUMENT_ROOT	/usr/dd/httpd/htdocs
setenv	PATH_INFO	/users/mem/ft/test

*/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <ctype.h>
#include <string.h>

#include <mml/mml.h>

#include <mml/mml-cgi.h>


/* Local Definitions */


/* External data referenced */


/* External routines used */


/* Local data publicly available */


/* Local routines and forward references */


/* Private data */


main( argc, argv )
	int		argc;
	char		**argv;
{
	void		*qP;
	char		*errP;
	char		*tagP;
	char		*lasttagP;
	char		*valP;

    printf( "Content-Type: text/html\n" );
    printf( "\n" );

    /* Collect arguments */
    if ( ( errP = qargs_in( (char *)NULL ) ) != NULL ) {
	report_error( errP );
	exit( 0 );
    }

    qP = qarg_first();
    if ( qP != NULL ) {
	printf( "\n<p><h3>test arguments:</h3><br>\n" );
	printf( "<dl>\n" );
	lasttagP = "";
	while ( qP != NULL ) {
	    tagP = qarg_tag( qP );
	    valP = qarg_value( qP );
	    if ( stricmp( tagP, lasttagP ) != 0 ) {
		printf( "<p><dt>%s\n", tagP );
		printf( "<dd>%s\n", valP );
	    }
	    else {
		printf( "<p>%s\n", valP );
	    }

	    lasttagP = tagP;
	    qP = qarg_next( qP );
	}
	printf( "</dl>\n" );
    }
    else
	printf( "\n<p><h3>No arguments were found.</h3><br>\n" );

}



report_error( errP )
	char		*errP;
{
    printf( "\n<p>An error occured during processing:<br>\n" );
    printf( "%s\n", errP );

    printf( "\n" );
    printf( "Have you set up the proper Apache environment?\n" );
    printf( "Hint: see the header comments in the source file.\n" );
}
