/* Test of tmclock

	Copyright 2003,2004,2005,2006
		by Mark E. Mallett, MV Communications, Inc.

	See the "LICENSE" file for terms.
*/

#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <time.h>
#include <sys/time.h>

extern long atol();
extern time_t tmclock();

main( argc, argv )
int argc;
char ** argv;
{
	int	i;
	time_t	tval;
	struct tm *tmP;
	struct tm tmblock;

    if ( argc < 2 ) {
	fprintf( stderr, "requires a time value, e.g. the output of \"date +%%s\"\n" );
	exit( 1 );
    }

    tval = atol( argv[1] );

    tmP = localtime( &tval );
    print_tm( tmP );

    tmblock = *tmP;
    tval = tmclock( &tmblock );
    tmP = localtime( &tval );
    print_tm( tmP );


    tmblock = *tmP;
    tmblock.tm_sec = 0;
    tmblock.tm_min = 0;

    for ( i = tmblock.tm_hour; i >= 0; --i ) {
	tmblock.tm_hour = i;
	tval = tmclock( &tmblock );
	tmP = localtime( &tval );
	printf( "%d:  ", i );
	print_tm( tmP );
    }
}

print_tm( tmP )
    struct tm *tmP;
{
    printf( "%04d%02d%02d %02d:%02d:%02d  dst:%d\n",
	   tmP->tm_year + 1900,
	   tmP->tm_mon + 1,
	   tmP->tm_mday,
	   tmP->tm_hour,
	   tmP->tm_min,
	   tmP->tm_sec,
	   tmP->tm_isdst );
}
