/* mml-err.c -- Stub error routines for mml use

	Copyright 2003,2004,2005,2006
		by Mark E. Mallett, MV Communications, Inc.

	See the "LICENSE" file for terms.

Various mml functions call error routines with printf-style
arguments.  It's expected that the mml user may supply these,
but if they don't, here are some that will get linked in by
virtue of being in the library.

Included:

	error		Print message to stderr and exit.
	warning		Print message to stderr and return.

*/

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <sys/types.h>

#include <mml/mml.h>



/* Local definitions */



/* External data referenced */



/* External routines used */



/* Local data publicly available */



/* Local routines and forward references */



/* Private data */


/*

*//* error( fmtP, args... )

	Print an error and don't return.

Accepts :

	fmtP		printf-style format string
	args		printf arguments.

Returns :

	Nothing.

Notes :

	Assumes stdc with function prototypes.

	Original of this routine interfaced to an error handling system
	that trapped to handler(s) higher on the stack.  For this simple
	system, this routine just prints a message and exits.

*/

void
error ARGLIST( ( fmtP, va_decl ) )
   NFARG( char		*fmtP )		/* message format string */
    FARG( ... )				/* stdc variable arguments */
{
	va_list		ap;		/* varargs arg pointer */

    /* Start varargs */
    va_start( ap, fmtP );

    /* Do the output */
    vfprintf( stderr, fmtP, ap );
    fprintf( stderr, "\n" );

    va_end( ap );

    /* Exit with bad status */
    exit( 1 );
}
/*

*//* warning( fmtP, args... )

	Issue a warning message.

Accepts :

	fmtP		printf-style format string
	args		printf arguments.

Returns :

	Nothing.

Notes :

	Assumes stdc with function prototypes.

	Original of this routine interfaced with an error handling system
	that allowed trapping of the warnings by code.  But for this
	demo program, it simply prints a warning message and returns.

*/

void
warning ARGLIST( ( fmtP, va_decl ) )
   NFARG( char		*fmtP )		/* message format string */
    FARG( ... )				/* stdc variable arguments */
{
	va_list		ap;		/* varargs arg pointer */

    /* Start varargs */
    va_start( ap, fmtP );

    /* Do the output */
    vfprintf( stderr, fmtP, ap );
    fprintf( stderr, "\n" );

    va_end( ap );
}
