/* mml-fthread.c -- fake pthread stubs

	Copyright 2006
		by Mark E. Mallett, MV Communications, Inc.

	See the "LICENSE" file for terms.

This provides some stub functions to overlay some minimal pthread functions
that are called throughout mml.  If mml is configured with pthread support,
an application that does not want to drag in pthread overhead may call
the "mml-fthread()" function which will cause this module to be loaded
by the linker, replacing the simple pthread functions with no-op routines
and preventing the linker from bringing in the real pthread functions.

*/

#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>

#include <mml/mml.h>


/* Local definitions */



/* External data referenced */



/* External routines used */



/* Local data publicly available */



/* Local routines and forward references */



/* Private data */



/*

*//* mml_fthread()

	fake thread support

Accepts :


Returns :

	<nothing>

Notes :

	This is a function that does nothing.  Its purpose is to cause
	this module to be loaded from the mml library, which will in
	turn cause the other symbols in this module to be loaded, and
	thereby overlay the pthread functions of the same name (and
	hopefully inhibit the entire pthreads support system being
	dragged in).

*/

void
mml_fthread NOARGLIST
{
}
/*

*//* other pthread functions

	These are the stubs for the other minimal pthreads functions
	that the mml library might call.

*/

#ifdef	MML_PTHREADS

int pthread_mutex_destroy ARGLIST( (mutexP) )
    FARG( pthread_mutex_t  *mutexP )
{ return 0; }

int pthread_mutex_init ARGLIST( (mutexP, attrP) )
   NFARG( pthread_mutex_t  *mutexP )
    FARG( const pthread_mutexattr_t *attrP )
{ return 0; }

int pthread_mutex_lock ARGLIST( (mutexP) )
    FARG( pthread_mutex_t  *mutexP )
{ return 0; }

int pthread_mutex_unlock ARGLIST( (mutexP) )
    FARG( pthread_mutex_t  *mutexP )
{ return 0; }


#endif	/* MML_PTHREADS */
