/* mml-ttio.h -- definitions for the mml "ttio" module

	Copyright 2003,2004,2005,2006
		by Mark E. Mallett, MV Communications, Inc.

	See the "LICENSE" file for terms.

Contains some generic terminal I/O routines- mainly intended as
an adjunct to "mml-in" input stream stuff, but separated out here
so everbody doesn't have to include it.

*/


#ifndef	H_MML_TTIO		/* For multiple inclusions */
#define	H_MML_TTIO


    /* An object to hold information about a command line */
typedef struct {
    void	*tc_bstrP;	/* Ptr to BSTR.  Note that we declare
				   as void here so anyone including this
				   header doesn't have to know about BSTR
				   if they don't want to.
				*/
    char	*tc_promptP;	/* Prompt string for input */
    char	*tc_cpromptP;	/* Continuation prompt */
    BOOL	tc_contF;	/* If next line is a continuation line */
    BOOL	tc_insertF;	/* Whether inserting (vs overstrike) */
}  TTCMDLN;


    /* An object to keep track of a command line stream (for mml-in) */
typedef struct {
    TTCMDLN	*ts_cmlP;	/* Ptr to command line object */
    int		ts_fetchX;	/* Index to next char to fetch.  (we could
				    use the bs_bX index in the BSTR but
				    this allows something else to use that
				    if it wants to.)
				*/
}  TTCMDSTR;


/* Declarations for functions contained in this module: */

    /* Input a command line from the terminal */
BOOL	tt_cmdline_input PROTO( (TTCMDLN *cmlP) );

    /* Input stream handler function(s): "ttcmd" stream */
void	in_h_ttcmd_finish PROTO( (MML_INS *instrP) );
int	in_h_ttcmd_getc PROTO( (MML_INS *instrP) );

    /* Push a terminal command line input stream onto an input stack */
BOOL	in_stream_push_ttcmd PROTO( ( MML_IN *inP, TTCMDLN *cmlP,
				        char *nameP ) );

    /* Allocate a new command line structure */
TTCMDLN	*tt_cmdline_new PROTO( (char *promptP, char *cpromptP) );

    /* Finish access to the terminal */
int	tt_fini PROTO( (void) );

    /* Input a single character from the terminal */
int	tt_inchar PROTO( (void) );

    /* Set up access to the terminal */
int	tt_init PROTO( (void) );

    /* Output a single character to the terminal */
int	tt_outchar PROTO( (char ch) );

    /* Output a NUL-terminated string to the terminal */
int	tt_puts PROTO( ( char *strP ) );


#endif	/* H_MML_TTIO */
