/* cltest.c -- simple test of terminal command line input

	Copyright 2003,2004,2005,2006
		by Mark E. Mallett, MV Communications, Inc.

	See the "LICENSE" file for terms.

*/

#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>

#include <mml/mml.h>

#include <mml/mml-in.h>
#include <mml/mml-ttio.h>


/* Local definitions */



/* External data referenced */



/* External routines used */



/* Local data publicly available */



/* Local routines and forward references */



/* Private data */


main( argc, argv )
  int argc;
  char **argv;
{
	int		ch;
	TTCMDLN		*cmlP;		/* Command line object */
	MML_IN		*inP;		/* Input stack object */

    inP = in_new();			/* Create new input object */
    if ( inP == NULL ) {
	fprintf( stderr, "in_new failed.\n" );
	exit( 1 );
    }

    cmlP = tt_cmdline_new( "Cmd> ", "---> " );
    if (cmlP == NULL ) {
	fprintf( stderr, "tt_cmdline_new failed.\n" );
	exit(1);
    }

    if ( !in_stream_push_ttcmd( inP, cmlP, "command line" ) ) {
	fprintf( stderr, "in_stream_push_ttcmd failed\n" );
	exit( 1 );
    }

    tt_init();

    tt_puts( "Enter line beginning with '.' to end.\n" );
    tt_puts( "\n" );

    for ( ; ; ) {
	ch = in_char( inP );
	if ( ch == '.' )
	    break;

	for ( ; ; ) {
	    tt_outchar( ch );
	    if ( ch == '\n' )
		break;
	    ch = in_char( inP );
	}
	tt_outchar( '\n' );
    }

    tt_fini();
}
