/* intest.c -- simple test of input stuff

	Copyright 2003,2004,2005,2006
		by Mark E. Mallett, MV Communications, Inc.

	See the "LICENSE" file for terms.

*/

#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <string.h>

#include <mml/mml.h>

#include <mml/mml-in.h>


/* Local definitions */



/* External data referenced */



/* External routines used */



/* Local data publicly available */



/* Local routines and forward references */



/* Private data */

char	*Strs[] = {
		"\n",
		"This is a copy of my given file.\n",
		"\n",
		NULL };

main( argc, argv )
  int argc;
  char **argv;
{
	int		ch;
	int		i;
	FILE		*fP;		/* Input file */
	MML_IN		*inP;		/* Input stack */

    if ( argc < 2 ) {
	fprintf( stderr, "Need a file name.\n" );
	exit( 1 );
    }

    if ( ( fP = fopen( argv[1], "r" ) ) == NULL ) {
	fprintf( stderr, "Can't open \"%s\" for input\n", argv[1] );
	exit( 1 );
    }
    inP = in_new();			/* Create new input object */
    if ( inP == NULL ) {
	fprintf( stderr, "in_new failed.\n" );
	exit( 1 );
    }
    if ( !in_stream_push_file( inP, fP, "source file" ) ) {
	fprintf( stderr, "in_stream_push_file failed for source file\n" );
	exit( 1 );
    }

    for ( i = 0; Strs[i] != NULL; ++i ) {
	if ( !in_stream_push_newstr( inP, Strs[i], strlen(Strs[i]), NULL ) ) {
	    fprintf( stderr, "in_stream_push_newstr failed for string %d \n",
				i);
	}
    }
	

    while ( ( ch = in_char( inP ) ) != EOF )
	putchar( ch );
}
