/* mml-base64.h -- definitions for the mml "base64" module

	Copyright 2005,2006
		by Mark E. Mallett, MV Communications, Inc.

	See the "LICENSE" file for terms.

Functions for base64 encoding/decoding.

Yep there are tons of these around; this implementation gives me
capability of intermediate/incremental operation, for example so that I
can use them in MML_IN streams).  There may be tons of those around too,
but for something simple like this, it's just as easy to cobble it up.

For base64 definitions, see e.g. RFC1421 and others.

*/


#ifndef	H_MML_BASE64		/* For multiple inclusions */
#define	H_MML_BASE64


    /* Special internal value that will represent the pad byte; this
       value has to be coordinated with its placement in the encoded
       character array, and/or the logic used.
    */
#define	B64PADX		64

    /* A handle for base64 operation. */
typedef struct {
    UBYTE	b64_bX;		/* How many bytes are buffered */
    UBYTE	b64_pX;		/* How many pad bytes have been decoded */
    UBYTE	b64_b[4];	/* Any buffered bytes */
}  MMLB64;


/* Declarations for functions contained in this module: */

    /* Completely decode a base64-encoded buffer */
int	b64_decode PROTO( (UBYTE *srcP, int srcL,
			   char *dstP, int dstL) );

    /* Decode another byte of base64 encoded data */
int	b64_decode_byte PROTO( (MMLB64 *b64P, UBYTE ch,
				char *dstP, int dstL) );

    /* Finish decoding */
int	b64_decode_finish PROTO( (MMLB64 *b64P,
				char *dstP, int dstL) );

    /* Partly decode (continue decoding?) a base64 data buffer */
int	b64_decode_part PROTO( (MMLB64 *b64P,
				UBYTE *srcP, int srcL,
				char *dstP, int dstL) );

    /* Decode the final part of (aka the rest of) base64 encoded data */
int	b64_decode_rest PROTO( (MMLB64 *b64P,
				UBYTE *srcP, int srcL,
				char *dstP, int dstL) );

    /* Determine buffer size required to hold a full or continued decoding */
int	b64_decode_size PROTO( (int srcL) );

    /* Completely encode a source data buffer into base64 */
int	b64_encode PROTO( (UBYTE *srcP, int srcL,
			   char *dstP, int dstL) );

    /* Encode another byte of source data */
int	b64_encode_byte PROTO( (MMLB64 *b64P, UBYTE ch,
				char *dstP, int dstL) );

    /* Finish encoding */
int	b64_encode_finish PROTO( (MMLB64 *b64P,
				char *dstP, int dstL) );

    /* Partly encode (continue encoding?) a source data buffer */
int	b64_encode_part PROTO( (MMLB64 *b64P,
				UBYTE *srcP, int srcL,
				char *dstP, int dstL) );

    /* Encode the final part of (aka the rest of) source data */
int	b64_encode_rest PROTO( (MMLB64 *b64P,
				UBYTE *srcP, int srcL,
				char *dstP, int dstL) );

    /* Determine buffer size required to hold a full or continued encoding */
int	b64_encode_size PROTO( (int srcL) );

    /* Initialize base64 handle */
void	b64_init PROTO( (MMLB64 *b64P) );

#endif	/* H_MML_BASE64 */
