/* mml-cgi.h -- Definitions for the mml "cgi" module

	Copyright 1994,2003,2004,2005,2006
		by Mark E. Mallett, MV Communications, Inc.

	See the "LICENSE" file for terms.

Some functions to help with Apache CGI web interface.

*/

#ifndef	H_MML_CGI
#define	H_MML_CGI


/* Declarations for functions contained in this module: */

    /* Get CGI query arguments */
char	*qargs_in PROTO( (char *method) );

    /* Find a handle for a specific tag */
void	*qarg_find_tag PROTO( (char *tagP) );

    /* Return the first tag registered */
void	*qarg_first PROTO( (void) );

    /* Get the tag that follows the specified one */
void	*qarg_next PROTO( (void *handleP) );

    /* Put a tag/value pair into the tag list */
BOOL	qarg_put PROTO( (char *tagP, char *valP ) );

    /* Access the tag of a tag/value handle */
char	*qarg_tag PROTO( (void *handleP) );

    /* Access the value of a tag/value handle */
char	*qarg_value PROTO( (void *handleP) );

    /* Replace the value of a tag/value handle */
char	*qarg_value_set PROTO( (void *handleP, char *valP) );

#endif	/* H_MML_CGI */
