/* tmclock.c -- Convert tm struct to a clock value.

        Taken from my 'wrap', but really taken from sources listed below.

This is a PD routine that fills in one of the major holes in the suite
of time conversion functions.  Read on...

Also contains xlocaltime() if using OS/2, which I had to include with TIMEX
because the standard localtime() function doesn't work correctly in the
non-root thread.  Sheesh!

mem 19960408: fix so that tm_year in the range of 100 - 138 work correctly.
Whoever wrote this assumed that any year less than 100 needs to have 1900
added to it (which is generally correct), but not otherwise (which is not
generally correct)

mem 19960615: attempt to use mktime() library function if available.

mem 19961104: need timezone offset to be daylight-saving-time-neutral,
fix the case where timezone offset is derived from current clock's
gmtoff

mem 2005: make it include mml.h to, among other things, pick up
results of autoconf.  

*/

#include <mml/mml.h>

#include <stdio.h>
#include <memory.h>
#include <sys/types.h>
#include <time.h>

#ifdef UNIX_BSD
#include <sys/time.h>
#endif


#ifdef	__bsdi__	/* mem 19960615 */
#define	USE_MKTIME
#endif

#undef	USE_MKTIME	/* mem, actually mktime() doesn't work well. */

#ifdef	USE_MKTIME	/* mem 19960615 */

time_t
tmclock( tm )
struct tm *tm;
{
    tm->tm_isdst = -1;		/* Make mktime figure it out */
    return ( mktime( tm ) );
}
#else	/* USE_MKTIME */


#ifdef OS2

static  struct tm        xtmblk;

struct tm *
xlocaltime(
        time_t          *timeP
        ) {

        time_t          timval;

    memcpy( &xtmblk, localtime( timeP ), sizeof( struct tm ) );

    /* Fix up hours and minutes and seconds */
    timval = *timeP - timezone;
    xtmblk.tm_sec = (int)((long)timval % 60);
    xtmblk.tm_min = (int)(((long)timval / 60 ) % 60);
    xtmblk.tm_hour = (int)(((long)timval / 3600 ) % 24);

    return( &xtmblk );
}

#endif /* OS2 */

/*

*//* os_tmclock( tmP )

	Convert tm struct to time value

Stolen from Arc 5.21 sources and inserted here in original form
(except for any changes needed for os-specific time representation).

*/

/************************* begin tmclock.c *****************************/

/*
 * Stolen from the Arc 5.21 sources...
 *
 * Stolen from Jef Poskanzer's tws time library, which was stolen from
 * Marshall Rose's MH Message Handling system...
 *
 * tmclock() will convert time from a tm struct back to a clock value.
 * tmjuliandate() converts a tm struct to its julian day number.
 * tmsubdayclock() takes hours, minutes, and seconds from a tm struct
 * and returns the number of seconds since midnight of that day. (?)
 *  -- Howard Chu, August 1 1988      hyc@umix.cc.umich.edu, umix!hyc
 */

/* $Header: tmclock.c,v 1.3 88/08/02 14:15:58 hyc Exp $ */

/* Julian day number of the Unix* clock's origin, 01 Jan 1970. */
#define JD1970 2440587L
#define	CENTURY	19

long	tzone;

long
tmjuliandate( tm )
struct tm *tm;
    {
    register int mday, mon, year;
    register long a, b;
    double jd;

    if ( (mday = tm -> tm_mday) < 1 || mday > 31 ||
	    (mon = tm -> tm_mon + 1) < 1 || mon > 12 ||
	    (year = tm -> tm_year) < 1 || year > 10000 )
	return ( -1L );

/* mem change from 100 to 200 here.  */
    if ( year < 200 )
	year += CENTURY * 100;

    if ( mon == 1 || mon == 2 )
	{
	--year;
	mon += 12;
	}
    if ( year < 1583 )
	return ( -1L );
    a = year / 100;
    b = 2 - a + a / 4;
    b += (long) ( (double) year * 365.25 );
    b += (long) ( 30.6001 * ( (double) mon + 1.0 ) );
    jd = mday + b + 1720994.5;
    return ( (long) jd );
    }


long
tmsubdayclock( tm )
struct tm *tm;
    {
    register int sec, min, hour;
    long result;
#if	UNIX_BSD
# ifndef __bsdi__
    {
       struct timeval tp;
       struct timezone tzp;

       gettimeofday(&tp, &tzp);
#ifdef OUT
       daylight=tzp.tz_dsttime;
#endif
       tzone=tzp.tz_minuteswest*(-60);
    }
# else /* bsdi */
    {
        struct tm *tmcheck;

	/* get DST-neutral timezone */
	time( &result );
	tmcheck = localtime( &result );
	tzone = tmcheck->tm_gmtoff;
	if ( tmcheck->tm_isdst )	/* mem 19961104 */
	    tzone -= (60 * 60);		/* mem 19961104 */
    }
# endif /* __bsdi__ */
#else
    tzset();
    tzone = -timezone;	/* declared as extern in SYSV <time.h> */
#endif
    if ( (sec = tm -> tm_sec) < 0 || sec > 59 ||
	    (min = tm -> tm_min) < 0 || min > 59 ||
	    (hour = tm -> tm_hour) < 0 || hour > 23 )
	return ( -1L );

    result = ( (long)hour * 60 + min ) * 60 + sec;
    result -= tzone;

    return ( result );
    }


time_t
tmclock( tm )
struct tm *tm;
    {
    register long jd, sdc;
    time_t result;
    struct tm *tmcheck;

    if ( ( jd = tmjuliandate( tm ) ) == -1L )
	return ( -1L );
    if ( ( sdc = tmsubdayclock( tm ) ) == -1L )
	return ( -1L );

    result = ( jd - JD1970 ) * 24 * 60 * 60 + sdc;

#ifndef	OS_MSDOS		/* MSDOS doesn't know from dst */
    /* Convert back to swag the dst flag */
    tmcheck = localtime( &result );
    if ( tmcheck->tm_isdst )
	result -= 60 * 60;
#endif  /* OS_MSDOS */

    return ( result );
    }

#endif	/* USE_MKTIME   19960615 */

/************************* end tmclock.c *******************************/

