/* mml-symtab.h -- definitions for the mml "symtab" module

	Copyright 2003,2004,2005,2006,2007
		by Mark E. Mallett, MV Communications, Inc.

	See the "LICENSE" file for terms.

mml-symtab contains routines to manipulate hashed symbol tables.

*/



#ifndef	H_MML_SYMTAB		/* For multiple inclusions */
#define	H_MML_SYMTAB



    /* Symbol table entry.  This is the part of an entry that's
       manipulated directly by the main symbol table maintenance
       routines.  Some of the maintenance routines give the
       address of this structure to other routines which know about
       specific types of entries (perhaps an external routine).
       Those other routines must be able to find more complete
       information from just this overhead address.  The recommended
       thing is to use this structure as the first element in a
       larger enclosing structure for the type of symbol being
       maintained.
    */
typedef struct syment {
    struct syment *se_nextP;		/* Next one in bucket list */
  } SYMENT;


    /* Symbol table control structure.  Anybody using a symbol table
       will do so via one of these.
    */
typedef struct {
    UWORD	st_flags;		/* Symbol table flags */
    UWORD	st_hashsize;		/* Hash size */
    SYMENT	**st_bucketPP;		/* Symbol table buckets */

#ifdef	MML_PTHREADS
    pthread_mutex_t st_lock;		/* For contention locking */
#endif  /* MML_PTHREADS */

        /* Control functions for symbol manipulations */

    UWORD	(*st_hash)();		/* Hash function */
    int		(*st_compare)();	/* Key compare */
    BOOL	(*st_keyassoc)(); 	/* Associate key with entry */
    BOOL	(*st_keydis)();		/* Disassociate key from entry */
  } SYMTAB;


    /* Symbol table prolog for symbols whose key is a string (a name) */
typedef
  struct {
    SYMENT	ss_sym;			/* Basic symbol prolog */
    char	*ss_nameP;		/* Symbol name */
  } SYMSTR;




/* Declarations for functions contained in this module: */

    /* Comparison routine for SYMSTR types */
int	symtab_comp_str PROTO( ( SYMSTR *symP, char *keyP ) );

    /* Create a new symbol table */
SYMTAB	*symtab_create PROTO( ( UWORD flags, UWORD hashsize,
		        UWORD (*hashrtc)(), int (*comprtc)(),
			BOOL (*keyassoc)(), BOOL (*keydis)() ) );

    /* Delete a symbol table */
void	symtab_delete PROTO( (SYMTAB *tableP) );

    /* Enter a new entry into a symbol table */
SYMENT	*symtab_enter PROTO( ( SYMTAB *tableP, void *keyP, int size ) );

    /* Hash routine for SYMSTR types */
UWORD	symtab_hash_str PROTO( ( char *keyP ) );

    /* Key association routine for string type key */
BOOL	symtab_keyassoc_str PROTO( ( SYMSTR *symP, char *keyP ) );

    /* Key disassociation routine for string type key */
BOOL	symtab_keydis_str PROTO( ( SYMSTR *symP ) );

    /* Find a symbol table entry given its key */
SYMENT	*symtab_lookup PROTO( (SYMTAB *tableP, void *keyP) );

    /* Remove a symbol table entry given its key */
void	symtab_remove PROTO( (SYMTAB *tableP, void *keyP) );


#endif	/* H_MML_SYMTAB */
