/* mml.h -- general mml (mm library) definitions

	Copyright 2003,2004,2005,2006,2007
		by Mark E. Mallett, MV Communications, Inc.

	See the "LICENSE" file for terms.

    derived mainly from my "portab.h" carried around since
    the mid 1980s or so.

*/

#ifndef	H_MML			/* For multiple inclusions */
#define	H_MML

#include <mml/mml-autoconf.h>


    /* Special character value(s) that may be used by mml modules.
       To avoid problems, e.g. to allow as stream to return EOF,
       CHV_EOF has to be the same as EOF.  So we define these hackishly.
      (too bad I can't have a descending enum sequence.)
    */

#define	CHV_EOF		EOF		/* End of file, error, or
					   otherwise no more input.
					*/

#define	CHV_EOD		((EOF)-1)	/* End of data (may be used to
					   signal EOF without other
					   implications, depending on
					   the module.
					*/




    /* I/O result information; used by some modules that do I/O
       and have information to retain about that I/O.
    */
typedef enum {
    IOR_NONE,			/* Nothing in particular */
    IOR_TIMEOUT,		/* Operation timed out */
    IOR_FAIL,			/* Some internal failure */
    IOR_EOF,			/* End of file */
    IOR_ERRNO,			/* As indicated by errno */
}  IORESULT;




#ifdef	MML_PTHREADS
# include <pthread.h>

    /* Some handy-dandy macros to make use of pthread locks */
# define mml_mutex_destroy( lvar )  pthread_mutex_destroy( lvar )
# define mml_mutex_init( lvar )     pthread_mutex_init( lvar, NULL )
# define mml_mutex_lock( lvar )     pthread_mutex_lock( lvar )
# define mml_mutex_unlock( lvar )   pthread_mutex_unlock( lvar )

#else

    /* No pthreads -- handy-dandy macros that do nothing */
# define mml_mutex_destroy( lvar ) 0
# define mml_mutex_init( lvar ) 0
# define mml_mutex_lock( lvar ) 0
# define mml_mutex_unlock( lvar ) 0
    
#endif  /* MML_PTHREADS */


#ifndef	MML_HAVE_VA_COPY

    /* This is a really hackish workaround for the lack of va_copy.
       It's known to work on some systems.
    */
# define va_copy( new, old ) (new) = (old);

#endif	/* MML_HAVE_VA_COPY


    /* These will get autoconf'd but for now define them here */
#define	OS_UNIX	1
#define UNIX_BSD	1


    /* For mml-iopf:
       In Feb 2005 various mml-iopf functions that took input from a
       (FILE *) file were renamed to have a leading 'f' character, so
       that 'i' versions of the functions could be added and the names
       could be more regular.  You can define this if you don't want to
       update the code that calls these functions.  Or you could define
       this in the application that includes mml-iopf.h .  This will
       enable the creation of macros for the old function names mapping
       to the new names.  Personally I'd recommend updating the
       applications that use them.  I'm probably the only one, but what
       the hey.
    */
/* #define MML_OLD_IOPFNAMES */


#ifndef	TRUE
#define	TRUE	1
#define	FALSE	0
#endif	/* TRUE */

#ifndef	NULL				/* The NULL pointer */
    /* Note we use "0" and not a pointer value.  It is correct to cast
       NULL and let the C compiler translate from "0".
    */
#define	NULL	0
#endif	/* NULL */

#ifndef	NUL				/* The character constant NUL */
#define	NUL	'\0'
#endif	/* NUL */


    /* Some types for storage sizes */
typedef	char		BYTE;		/* 8-bit */
typedef unsigned char	UBYTE;		/* Unsigned 8-bit */
typedef	char		BOOL;		/* Whatever's best for true/false */
typedef	short		WORD;		/* 16-bit */
typedef unsigned short	UWORD;		/* Unsigned 16-bit */
typedef	long		LONG;		/* At least 32 bit */
typedef unsigned long	ULONG;		/* Unsigned 32-bit */

/* bool_t may or may not be defined on the local system.  Comment it out
   here if it offends... */
#ifndef	bool_t
typedef	int	bool_t;
#endif


/* These macros let you define function prototypes regardless of
   whether the C compiler in use supports them.  Not such a big
   deal these days when it's hard to find a compiler that doesn't
   have them.  Nevertheless, old habits..

Declare a function like this:

For no argument list:
    int function NOARGLIST;

For an argument list:
    int function ARGLIST( (a,b,c) )
       NFARG( int a )
       NFARG( int b )
        FARG( char *c )

"NFARG" is "non-final argument" and "FARG" is "final argument"

For a function reference:
    int function PROTO( (int a, int b, char *c) );

*/


    /* Define USE_PROTOS if the C compiler supports prototypes */
#if __STDC__
#  ifndef NOPROTOS
#    define	USE_PROTOS
#  endif
#endif

#ifdef	USE_PROTOS

    /* Macro definitions that use underlying prototypes */
#define	PROTO( def )	def
#define	NOARGLIST	( void )
#define	ARGLIST( args ) (
#define	NFARG( def )	def,
#define	FARG( def )	def )

#else

    /* Macro definitions for more backwards compilers (no prototypes) */
#define	PROTO( def )	()
#define	NOARGLIST	()
#define	ARGLIST( args )	args
#define	NFARG( def )	def;
#define	FARG( def )	def;

#endif	/* USE_PROTOS */


#endif	/* H_MML */
