/* mml-alloc.h -- definitions for the mml memory allocation module

	Copyright 2003,2004,2005,2006,2007
		by Mark E. Mallett, MV Communications, Inc.

	See the "LICENSE" file for terms.

Contains memory allocation routines. 

Basically front-ends to library routines, but

  a) care is taken to pass descriptive strings that can be used
     in error reporting and debugging;
  b) one can always alter these functions to do specialized things
     if desired at some later time.  That can be important for
     memory management functions.

*/


#ifndef	H_MML_ALLOC		/* For multiple inclusions */
#define	H_MML_ALLOC

    /* Minimum allocation size (mainly for rualloc stuff) */
#define	MML_ALLOC_MIN		16

    /* Alignment (chunk size for allocation) */
#define	MML_ALLOC_ALIGN		8

    /* The # of bits to shift to get MML_ALLOC_ALIGN alignment */
#define	MML_ALLOC_ALIGN_SHIFT	3

    /* Mask corresponding to those bits (I suppose we could calculate these) */
#define	MML_ALLOC_ALIGN_MASK	0x7

    /* Maximum memory size that can be reused via rualloc */
#define	MML_ALLOC_RUMAX		1024


    /* Hack for declaring data for module, extern for users */
#ifndef	MML_ALLOC
  #define MML_ALLOC	extern
#endif

    /* Data declared by this module */
MML_ALLOC int	Mml_emallocC;		/* Number of emalloc calls */
MML_ALLOC int	Mml_ereallocC;		/* Number of erealloc calls */

/* Declarations for functions contained in this module: */

    /* Deallocate memory */
void	dealloc PROTO( (void *memP) );

    /* Release memory for later re-use.  Shame that caller must pass size. */
void	derualloc PROTO( (void *memP, size_t size) );

    /* Allocate memory */
void	*emalloc PROTO( (char *facP, char *noteP, size_t size) );

    /* Reallocate memory */
void	*erealloc PROTO( (char *facP, char *noteP, void *oldP, size_t size) );

    /* Allocate memory, first checking re-use bins.  Dumb name? */
void	*erualloc PROTO( (char *facP, char *noteP, size_t size) );

#ifdef	MML_MALLOC_DEBUGGING
BOOL	mml_malloc_dump PROTO( (FILE *ofP) );
#endif	/* MML_MALLOC_DEBUGGING */

    /* Initialize mml-alloc stuff */
BOOL	mml_alloc_init PROTO( (void) );

    /* Make a new copy of a NUL-terminated string */
char	*newstr PROTO( (char *facP, char *nameP, char *oldP) );

    /* Make a new nul-terminated string from a counted string */
char	*newstr_n PROTO( (char *facP, char *nameP, char *oldP, int len) );


#endif	/* H_MML_ALLOC */
