/*  mml-bio.h -- definitions for the mml "bio" module

	Copyright 2003,2004,2005,2006,2007
		by Mark E. Mallett, MV Communications, Inc.

	See the "LICENSE" file for terms.

Some basic buffered I/O functions.

*/


#ifndef	H_MML_BIO		/* For multiple inclusions */
#define	H_MML_BIO

#define	BIO_BUFLEN	512	/* Default buffer size for bio */
#define	BIO_BUFMIN	512	/* Minimum buffer size for bio */
#define	BIO_BUFMAX	10240	/* Maximum buffer size for bio */

    /* A handle for the mml-bio operations. */
typedef struct {
    int		bio_fd;		/* File descriptor */
    UBYTE	*bio_bufP;	/* I/O buffer */
    int		bio_tosec;	/* Timeout in seconds */
    long	bio_tousec;	/* Timeout in microseconds */
    int		bio_errret;	/* Value to return upon input error. */
    int		bio_bufL;	/* Size of buffer */
    int		bio_bufC;	/* Number of bytes in buffer */
    int		bio_bufX;	/* Access point in buffer where relevant */
    IORESULT	bio_result;	/* Extended result information */
    int		bio_errno;	/* Errno where appropriate */
}  BIO;

    

/* Declarations for functions contained in this module: */

    /* Set buffer size for IO */
void	bio_bufsiz_set PROTO( (BIO *bioP, int bufL) );

    /* Write any buffered data to BIO */
BOOL	bio_drain PROTO( (BIO *bioP) );

    /* Fill next input buffer */
BOOL	bio_fill PROTO( (BIO *bioP) );

    /* Finialize a control structure for I/O */
void	bio_finit PROTO( (BIO *bioP) );

    /* Input a byte via BIO */
int	bio_getb PROTO( (BIO *bioP) );

    /* See if there are any bytes available for fetching */
BOOL	bio_getb_check PROTO( (BIO *bioP, int tosec, long tousec) );

    /* Init control structure for IO */
void	bio_init PROTO( (BIO *bioP, int fd) );

    /* Init buffer for an BIO */
BOOL	bio_initbuf PROTO( (BIO *bioP) );

    /* Output a byte via BIO */
BOOL	bio_putb PROTO( (BIO *bioP, UBYTE bval) );

    /* Output a number of bytes via BIO */
BOOL	bio_putn PROTO( (BIO *bioP, UBYTE *bP, int bC) );

    /* Output from a nul-terminated string */
BOOL	bio_putstr PROTO( (BIO *bioP, UBYTE *bP) );

    /* Set timeout for IO */
void	bio_timeout_set PROTO( (BIO *bioP, int tosec, long tousec) );

    /* Take back a byte after bio_getb() */
void	bio_ungetb PROTO( (BIO *bioP, UBYTE bval) );

    /* Input stream handler function(s): BIO stream */
int	in_h_bio_getc PROTO( ( MML_INS *instrP ) );

    /* Push a BIO onto an input stream */
BOOL	in_stream_push_bio PROTO( (MML_IN *inP, BIO *bioP, char *nameP) );


#endif	/* H_MML_BIO */
