/* mml-ll.h -- definitions for the mml "ll" module

	Copyright 2003,2004,2005,2006,2007
		by Mark E. Mallett, MV Communications, Inc.

	See the "LICENSE" file for terms.

General Linked List stuff.

Note that the default list is a doubly linked list (forward and
back).  That's wasteful for many cases but this isn't 1975 any
more.  These days it's more productive to waste a few cycles and
a few bytes than it is to think about it.  (Hey, that's what
cheap machines do to us.)

*/


#ifndef	H_MML_LL		/* For multiple inclusions */
#define	H_MML_LL


typedef struct ll_node {		/* Linked List node */
    struct ll_node	*lln_nextP;	/* Ptr to next one */
    struct ll_node	*lln_prevP;	/* Ptr to previous one */
    struct ll_head	*lln_hdrP;	/* Ptr to the list header */
    void		*lln_valP;	/* Ptr to payload (value) */
}  LL_NODE;


typedef struct ll_head {		/* Linked List head */
    struct ll_node	*llh_firstP;	/* Ptr to first one */
    struct ll_node	*llh_lastP;	/* Ptr to last one */
    int			llh_nodeC;	/* Number of nodes */

#ifdef MML_PTHREADS
    pthread_mutex_t	llh_lock;	/* Lock for critical section */
#endif /* MML_PTHREADS */

}  LL_HEAD;


/* Declarations for functions contained in this module: */

    /* Init a linked list */
void	ll_init PROTO( ( LL_HEAD *hdrP ) );

    /* Finalize (destroy) a linked list */
void	ll_finit PROTO( (LL_HEAD *hdrP) );

    /* Allocate a new list node */
LL_NODE	*ll_node PROTO( (char *noteP) );

    /* Release a previously allocated node */
void	ll_node_free PROTO( (LL_NODE *nodeP) );

    /* Add value before an existing list node */
LL_NODE	*ll_addvb PROTO( (LL_HEAD *hdrP, LL_NODE *nnodeP, void *valP) );

    /* Add value to head of list */
LL_NODE	*ll_addvh PROTO( ( LL_HEAD *hdrP, void *valP ) );

    /* Add value in sorted place in list */
LL_NODE *ll_addvs PROTO( ( LL_HEAD *hdrP, void *valP, int (*cmp)() ) );

    /* Add value to tail of list */
LL_NODE *ll_addvt PROTO( ( LL_HEAD *hdrP, void *valP ) );

    /* Remove a node from a list */
void	ll_rem PROTO( (LL_NODE *nodeP) );

    /* Remove a node from a list but don't lock the list (e.g. when the
       caller has already locked it.
    */
void	ll_rem_nolock PROTO( (LL_NODE *nodeP) );

#endif	/* H_MML_LL */
