/* avltest.c -- test program for mml AVL routines

	Copyright 2003,2004,2005,2006
		by Mark E. Mallett, MV Communications, Inc.

	See the "LICENSE" file for terms.

*/

#include <stdio.h>


#include <mml/mml.h>

#include <mml/mml-alloc.h>
#include <mml/mml-avl.h>


/* Structure of node used by the test routine */

typedef
  struct atnode {
    AVLNODE	at_avl;			/* AVL info */
    long	at_data;		/* key && data */
  } ATNODE;

extern	long	atol();
extern	double	drand48();

static	int	tkeycmp();
static	AVLNODE	*tmknode();
static	int	tprnode();
static	int	trmnode();

	int	Comps = 0;
	int	Nodes = 0;
	AVLTREE	Treehdr;

main()
{
	int		c;
	int		i;
	int		done;
	int		sts;
	long		key;
	char		*strP;
	char		linebuf[100];

    /* Construct a tree header */
    avlnew( &Treehdr, tkeycmp, tmknode, trmnode );

    for ( done = FALSE; !done ; ) {
	printf("> ");
	fflush( stdout );
	getline( &linebuf[0] );
	if ( linebuf[0] == NUL )
	    continue;
	for( strP = &linebuf[1]; ( c = *strP ) != NUL; ++ strP )
	    if ( ( c != ' ' ) && ( c != '	' ) )
		break;

	switch( linebuf[0] ) {
	    case '0':			/* Default add */
	    case '1':
	    case '2':
	    case '3':
	    case '4':
	    case '5':
	    case '6':
	    case '7':
	    case '8':
	    case '9':
		strP = &linebuf[0];
	    case 'a':			/* Add */
		key = atol( strP );
		sts = avlinsert( &Treehdr, &key, &key );
		if ( sts == 0 ) {
		    printf( "ok.\n" );
		    ++Nodes;
		}
		else if ( sts == -1 ) {
		    printf( "fatal error.\n" );
		    done = TRUE;
		}
		else
		    printf( "Already in tree.\n" );
	 	break;		

	    case 'd':			/* Delete a member */
		key = atol( strP );
		if ( ( sts = avldelete( &Treehdr, &key ) ) >= 0 ) {
		    printf( "ok.\n" );
		    --Nodes;
		}
		else
		    printf( "not found.\n" );
	 	break;

	    case 'e':			/* Erase the tree */
		avldeltree( &Treehdr );
		Nodes = 0;
		Comps = 0;
	 	break;

	    case 'p':			/* Print the tree */
		avlwalk( &Treehdr, tprnode );
	    case 's':			/* Give statistics */
		printf("Nodes: %d;  Comparisons: %d\n", Nodes, Comps );
	 	break;
	    
	    case 'r':			/* Add n random values */
		for( i = atoi( strP ); i > 0; --i ) {
		    key = ( drand48( ) * (double)10000.0 );
		    sts = avlinsert( &Treehdr, &key, &key );
		    if ( sts == -1 ) {
			printf( "fatal error.\n" );
			done = TRUE;
		 	break;
		    }
		    else if ( sts == 0 )
			++Nodes;
		}
	 	break;

	    case 'q':			/* Quit */
		done = TRUE;
	 	break;

	    case 'z':			/* Spin the random number generator */
		for( i = atoi( strP ); i > 0; --i )
		    key = (long)( drand48( ) * (double)10000.0 );
	 	break;

	    default:
		printf(
" ? a(dd), d(elete), e(mpty), p(rint), q(uit), r(andom), s(tats), or number.\n" );
	 	break;
	}
    }
}


getline( bufP )
	char		*bufP;
{
	int		c;

    while( (c = getchar()) != '\n' )
	*bufP++ = c;
    *bufP = NUL;
}

/* Node printing routine, called by avlwalk().
   It returns 0 always, indicating that tree walking should
   continue.  Note that a call with NULL nodeP indicates end
   of tree.
*/
static int
tprnode( treeP, nodeP, depth )
	AVLTREE		*treeP;		/* Ptr to tree header block */
	ATNODE		*nodeP;		/* Ptr to current node */
	int		depth;		/* Depth of node in tree */
{
	int		i;

    if ( nodeP != NULL ) {
	/* Tab over according to depth of node */
	for( i = 0; i < depth; ++i )
	    printf( "  " );
	printf( "key =%5ld;  val=%5ld;  bal=%2d\n", nodeP->at_data,
    					      nodeP->at_data,
    					      nodeP->at_avl.n_balance );
    }
    return( 0 );
}


/* The key comparison routine; it is passed the address of a key value,
   and the address of the node to which it is being compared.  In our
   case the AVLNODE address is the same as the ATNODE address so we'll
   assume we're being passed an ATNODE ptr.  
*/
static int
tkeycmp( val1, nodeP )
register long	*val1;
register ATNODE *nodeP;
{
	int		rval;

    if ( *val1 < nodeP->at_data )
	rval = -1;
    else if ( *val1 == nodeP->at_data )
	rval = 0;
    else
	rval = 1;

    ++Comps;
    return( rval );
}


/* Node maker.  Note it must return the address of the AVLNODE struct. */

static AVLNODE *
tmknode( treeP, keyP, dataP, enodeP )
	AVLTREE		*treeP;
	long		*keyP;
	long		*dataP;
	AVLNODE		*enodeP;
{
	ATNODE		*nodeP;

    /* Check for over-write of existing node */
    if ( enodeP != NULL )
	return( NULL );

    /* New node -- build it */
    nodeP = (ATNODE *)emalloc( "tmknode", "new node", sizeof(ATNODE) );
    if ( nodeP == NULL )
	return( NULL );
    nodeP->at_data = *keyP;

    return( &nodeP->at_avl );
}


static int
trmnode( treeP, nodeP )
	AVLTREE		*treeP;
	AVLNODE		*nodeP;
{
    dealloc( nodeP );
}

#ifdef bsdi
extern long random();

double
drand48()
{
    return ( ((float)random()) / 0x07fffffffL );
}
#endif
