/* bsex.c -- exercise BSTR functions

	Copyright 2003,2004,2005,2006
		by Mark E. Mallett, MV Communications, Inc.

	See the "LICENSE" file for terms.

*/

#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <time.h>

#include <mml/mml.h>

#include <mml/mml-alloc.h>
#include <mml/mml-ll.h>
#include <mml/mml-str.h>
#include <mml/mml-in.h>
#include <mml/mml-iopf.h>
#include <mml/mml-dns.h>

/* Local definitions */

#define	BSTRCOUNT	100
#define	BSTRLEN		50000

/* External data referenced */



/* External routines used */



/* Local data publicly available */



/* Local routines and forward references */



/* Private data */

static	MML_DNS		*DnsP;

main( argc, argv )
  int argc;
  char **argv;
{
	int		strC;		/* String counter */
	int		strX;		/* String index */
	int		cC;		/* Char count */
	char		ch;
	BSTR		*bstrP;		/* Byte string */

	time_t		timenow;
	char		refbuf[1000];
	BSTR		*bss[BSTRCOUNT];
	BSTR		*bssc[BSTRCOUNT];
	char		somebuf[1000];

    /* Create a reference buffer for later comparison */
    time( &timenow );
    sprintf( refbuf, "%ld %ld %s", timenow, (long)getpid(), ctime(&timenow) );

    /* Test creation and duplication of BSTRCOUNT bstrs filling
       them with BSTRLEN characters.
    */
    for ( strC = 0; strC < BSTRCOUNT; ++strC ) {
	bstrP = bstr_new( "a BSTR", 100, BSTRLEN );
	if ( bstrP == NULL ) {
	    fprintf( stderr, "bstr_new failed for strC = %d\n", strC );
	    exit( 1 );
	}
	bss[ strC ] = bstrP;

	/* Fill the string causing repeated expansion */
	for ( cC = 0; cC < BSTRLEN; ++cC ) {
	    ch = "abcdefghijklmnopqrstuvwxyz01234567890----"[ cC % 36 ];
	    bstr_putb( bstrP, ch );
	}

	/* Create a string to compare to refbuf.  All we are doing here
	   is trying to push down on the stack to see if something has
	   gotten corrupted.. looking for a coredump merely by invoking
	   some of these functions.
	*/

	sprintf( somebuf, "%ld %ld %s", timenow, (long)getpid(), ctime(&timenow) );
	if ( strcmp( refbuf, somebuf ) != 0 ) {
	    fprintf( stderr, "First buf comp fails for strC = %d\n", strC );
	    exit( 1 );
	}

	/* Duplicate the string and try again */
	bssc[ strC ] = bstr_dup( bstrP, 0 );
	
	sprintf( somebuf, "%ld %ld %s", timenow, (long)getpid(), ctime(&timenow) );
	if ( strcmp( refbuf, somebuf ) != 0 ) {
	    fprintf( stderr, "Second buf comp fails for strC = %d\n", strC );
	    exit( 1 );
	}

	printf( "String %d complete\n", strC );
    }

    /* Allocate a DNS handle-- again to exercise the stack */
    DnsP = mdns_new();

    printf( "No failure indicated.\n" );

    printf( "emalloc count: %d;  erealloc count: %d\n",
	       Mml_emallocC, Mml_ereallocC );

    exit ( 0 );
}
