/* bst.c -- Some tests of BSTRs

	Copyright 2003,2004,2005,2006
		by Mark E. Mallett, MV Communications, Inc.

	See the "LICENSE" file for terms.

*/

#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <time.h>

#include <mml/mml.h>

#include <mml/mml-alloc.h>
#include <mml/mml-ll.h>
#include <mml/mml-str.h>
#include <mml/mml-in.h>
#include <mml/mml-iopf.h>
#include <mml/mml-dns.h>

/* Local definitions */



/* External data referenced */



/* External routines used */



/* Local data publicly available */



/* Local routines and forward references */



/* Private data */


main( argc, argv )
  int argc;
  char **argv;
{
	REFSTR		*rs1P, *rs2P;
	BSTR		*bsP;

    printf( "adding rsp1 = 'hello here mem' and rsp2 = /here/ to end\n" );
    /* Make a refstr and create some data */
    rs1P = refstr_new( "first", 100, 10000 );
    if ( rs1P == NULL ) {
	warning( "rs1P/new failed." );
	exit( 1 );
    }

    bsP = refstr_bstr( rs1P );
    bstr_cat( bsP, "Hello here mem" );
    bstr_nulterm( bsP );

    /* Make a reference refstr and watch it */
    rs2P = refstr_ref( rs1P, 6, -1 );
    if ( rs2P == NULL ) {
	warning( "rs2P/ref failed." );
	exit( 1 );
    }

    bsprint( refstr_bstr( rs1P ), "bstr" );
    rsprint( rs1P, "rs1P" );
    rsprint( rs2P, "rs2P" );

    printf( "\nin rsp1, adding 't' to 'here'\n" );
    refstr_replacen( rs1P, 6, 6, (UBYTE *)"t", 1 );
    bsprint( refstr_bstr( rs1P ), "bstr" );
    rsprint( rs1P, "rs1P" );
    rsprint( rs2P, "rs2P" );

    printf( "\nin rsp2, prepending with 'over '\n" );
    refstr_replace( rs2P, 0, 0, (UBYTE *)"over " );
    bsprint( refstr_bstr( rs1P ), "bstr" );
    rsprint( rs1P, "rs1P" );
    rsprint( rs2P, "rs2P" );

    printf( "\nReplacing rsp2 with ''\n" );
    refstr_replace( rs2P, 0, refstr_len( rs2P ), (UBYTE *)"" );
    bsprint( refstr_bstr( rs1P ), "bstr" );
    rsprint( rs1P, "rs1P" );
    rsprint( rs2P, "rs2P" );
}


bsprint ARGLIST( (bsP, labelP ) )
   NFARG( BSTR		*bsP )
    FARG( char		*labelP )
{
    printf( "%s  bC=%d  bX=%d\n",
	     labelP,
	     bsP->bs_bC, bsP->bs_bX );
    printf( "    >" );
    fwrite( bsP->bs_bP, 1, bsP->bs_bC, stdout );
    printf( "<\n" );
}


rsprint ARGLIST( (rsP, labelP) )
   NFARG( REFSTR	*rsP )
    FARG( char		*labelP )
{
	int		startX, endX;
	BSTR		*bsP;

    startX = refstr_startx( rsP );
    endX = refstr_endx( rsP );
    bsP = refstr_bstr( rsP );

    printf( "%s  start=%d/%d  end=%d/%d  cur=%d/%d\n",
	     labelP,
	     rsP->rs_startX, startX,
	     rsP->rs_endX, endX,
	     rsP->rs_bX, rsP->rs_bX + startX );
    printf( "    >" );
    fwrite( bsP->bs_bP + startX, 1, endX - startX, stdout );
    printf( "<\n" );
}
