#!/bin/sh
#
#  dumb script to update copyrights.
#  mem 20070101
#
#	cru.sh filename oldyear newyear
#
#	filename says what file to update.  Makes a '.bak' copy.
#	oldyear is the expected last copyright year in the file.
#	newyear is the new year to append.
#
#	Looks for a line of the form:
#	    Copyright [anything]oldyear
#	and appends ",newyear" to that line.
#
#	Only changes the FIRST such line.

if [ $# -ne 3 ] ; then
    echo usage: $0 filename oldyear newyear
    exit 1
fi

fname="$1"
oldyear="$2"
newyear="$3"

if ! mv "${fname}" "${fname}.bak" ; then
    echo rename of "${fname}" to "${fname}.bak" failed.
    exit 1
fi

if ! sed "1,/Copyright.*${oldyear}$/ {
	s/${oldyear}$/${oldyear},${newyear}/
	} " ${fname}.bak > ${fname}; then
    echo sed failed.
    if ! mv "${fname}.bak" "${fname}" ; then
	rename of "${fname}.bak" to "${fname}" failed.
    fi
    exit 1
fi
