/* mml-avldb.h -- definitions for the mml "avldb" module

	Copyright 2003,2004,2005,2006,2007
		by Mark E. Mallett, MV Communications, Inc.

	See the "LICENSE" file for terms.

avldb provides a fairly simple interface to the avl tree functions,
allowing one to easily manage generic data in memory-- storing
and retrieving objects by a simple key.

*/


#ifndef	H_MML_AVLDB		/* For multiple inclusions */
#define	H_MML_AVLDB



/* Declarations for functions contained in this module: */


    /* Delete an item */
void	*avldb_delete PROTO( (int etype, char *enameP) );

    /* Find an item in the avldb tree */
void	*avldb_find PROTO( (int etype, char *enameP) );

    /* Initialize the avldb module */
void	avldb_init PROTO( (void) );

    /* Insert an item */
void	*avldb_insert PROTO( (int etype, char *enameP) );

    /* Set a "compare key" routine in place of the default */
void	avldb_set_cmpkey PROTO( (int (*rtc)() ) );

    /* Walk the tree */
void	avldb_walk PROTO( (int (*rtc)()) );

#endif	/* H_MML_AVLDB */
