/* mml-fmt.h -- definitions for the mml "fmt" module

	Copyright 2003,2004,2005,2006,2007
		by Mark E. Mallett, MV Communications, Inc.

	See the "LICENSE" file for terms.

Contains various formatting and conversion routines.

*/


#ifndef	H_MML_FMT		/* For multiple inclusions */
#define	H_MML_FMT


/* Declarations for functions contained in this module: */

    /* Convert decimal digit string to value */
long	atod PROTO( (char *strP) );

    /* Convert decimal digit string to unsigned long value */
ULONG	atodu PROTO( (char *strP) );

    /* Convert hex digit string to value */
long	atoh PROTO( (char *strP) );

    /* Convert octal digit string to value */
long	atoo PROTO( (char *strP ) );

    /* Convert "fullstr" (yyyymmdd[.hhmmss]) to time */
long	fullstr_to_time PROTO( (char *dstrP) );

    /* Convert two-string time (date string/time string) to time */
long	str2_to_time PROTO( (char *dstrP, char *tstrP) );

    /* Convert time to "fullstr" (yyyymmdd.hhmmss) */
char	*time_to_fullstr PROTO( (time_t timeval) );

    /* Convert time to yyyymmdd date string */
char	*time_to_yyyymmdd PROTO( (time_t timeval) );

    /* Convert time to hhmmss time string */
char	*time_to_hhmmss PROTO( (time_t timeval) );

#endif	/* H_MML_FMT */
