/* mml-ttio.msd

	Copyright 2003,2004,2005,2006,2007
		by Mark E. Mallett, MV Communications, Inc.

	See the "LICENSE" file for terms.

OS-specific support routines for mml-ttio.c,
  #included by mml-ttio.c for MSDOS

	This is all very ancient, who knows if it still works..

*/


#include <stdio.h>
#include <bios.h>


/* Local definitions */

	/* IBMPC keyboard scan codes */

#define	PCLEFT		0x4b00
#define	PCRIGHT		0x4d00
#define	PCHOME		0x4700
#define	PCEND		0x4f00
#define	PCINSERT	0x5200
#define	PCDELETE	0x5300


/* External data referenced */



/* External routines used */



/* Local data publicly available */



/* Local routines and forward references */



/* Private data */



/*

*//* tt_fini()

	Finish access to the terminal

Accepts :

	<none>

Returns :

	<value>		TRUE if OK
			FALSE if not.

Notes :

	Complement to tt_init()

*/

int
tt_fini NOARGLIST
{
    /* There is no special finalization under MSDOS */

    return( TRUE );
}
/*

*//* tt_inchar()

	Input a single character from the terminal

Accepts :



Returns :

	<value>		The character
			EOF if end

Notes :


*/

int
tt_inchar NOARGLIST
{
	unsigned int	keycode;	/* Code from bios */
	int		ch;		/* Character value */

    /* Repeatedly get keyboard code until a valid keycode is received */
    for ( ; ; ) {
	keycode = _bios_keybrd(_KEYBRD_READ);
	if ( keycode == 0 )		/* If nothing */
	    continue;			/*  ignore it */
	if ( ( ch = keycode & 0x7f ) != 0 )
	    break;			/* Valid  */

	/* Translate PC keyboard code to internal code, if any */
	switch( keycode ) {
	    case PCLEFT:
	    	ch = KCLEFT;
		break;

	    case PCRIGHT:
	    	ch = KCRIGHT;
		break;

	    case PCHOME:
	    	ch = KCHOME;
		break;

	    case PCEND:
	    	ch = KCEND;
		break;

	    case PCINSERT:
	    	ch = KCINSERT;
		break;

	    case PCDELETE:
	    	ch = KCDELETE;
		break;

	    default:
	    	ch = NUL;
		tt_outchar( '\007' );
		break;
	}

	if ( ch != 0 )
	    break;
	 
    }

    return( ch );
}
/*

*//* tt_init()

	Initialize the terminal

Accepts :

	<none>

Returns :

	<value>		TRUE if OK
			FALSE if not.

Notes :

	Sets up some static data,
	tt_fini() must be called to undo all this.

*/

int
tt_init NOARGLIST
{
    /* There is no special initialization under MSDOS */

    return( TRUE );
}
/*

*//* tt_outchar( ch )

	Output a single character to the termimal

Accepts :

	ch		The character to output

Returns :

	<value>		TRUE if OK
			FALSE if not

Notes :


*/

int
tt_outchar ARGLIST( (ch) )
    FARG( char		ch )		/* comment */
{
    return ( write( fileno(stdout), &ch, 1 ) == 1 );
}
/*

*//* tt_puts( strP )

	Output a NUL-terminated string

Accepts :

	strP		Ptr to string

Returns :

	<value>		TRUE if OK
			FALSE if not.

Notes :


*/

int
tt_puts ARGLIST( ( strP ) )
    FARG( char		*strP )		/* String to output */
{
    return ( write( fileno(stdout), strP, strlen( strP ) ) >= 0 );
}
