/* dnstest.c -- simple test of DNS stuff

	Copyright 2003,2004,2005,2006
		by Mark E. Mallett, MV Communications, Inc.

	See the "LICENSE" file for terms.

*/

#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/nameser.h>
#include <resolv.h>

#include <mml/mml.h>
#include <mml/mml-dns.h>


/* Local definitions */



/* External data referenced */



/* External routines used */



/* Local data publicly available */



/* Local routines and forward references */

void	doq PROTO( (MML_DNS *dnsP, char *qP, ns_type qt) );
void	qshow PROTO( (MML_DNS *dnsP) );

/* Private data */

	MML_DNS		*dnsP;

main( argc, argv )
  int argc;
  char **argv;
{

    /* Init DNS access */
    dnsP = mdns_new();
    if (dnsP == NULL ) {
	fprintf( stderr, "mdns_new failed.\n" );
	exit( 1 );
    }

    doq( dnsP, "www.mv.com", ns_t_a );
    doq( dnsP, "aol.com", ns_t_a );
    doq( dnsP, "33.85.125.199.in-addr.arpa", ns_t_ptr );
    doq( dnsP, "aol.com", ns_t_mx );
    doq( dnsP, "us.ibm.com", ns_t_mx );
}

void
doq ARGLIST( (dnsP, qP, qt) )
   NFARG( MML_DNS	*dnsP )		/* DNS handle */
   NFARG( char		*qP )		/* Ptr to query string */
    FARG( ns_type	qt )		/* query type */
{
    printf( "\n" );
    printf( "Query:  qp=\"%s\"   qt=%d\n", qP, qt );
    if ( !mdns_query( dnsP, qP, ns_c_in, qt ) ) {
	printf( "Failed.\n" );
    }
    else {
	do {
	    qshow( dnsP );
	} while ( mdns_ans_next( dnsP ) );
    }
}

void
qshow ARGLIST( (dnsP) )
    FARG( MML_DNS	*dnsP )		/* DNS handle */
{
	UBYTE		ip4[4];		/* IP4 octets */

    printf( " Result %d:  type=%d\n",
		dnsP->dn_ansX,
		dnsP->dn_anstype );

    switch( dnsP->dn_anstype ) {
	case	ns_t_a:
	    mdns_ip4_iptoba( htonl( dnsP->dn_ipaddr ), &ip4[0] );
	    printf( "   %d.%d.%d.%d\n",
		    ip4[0], ip4[1], ip4[2], ip4[3] );
	    break;

	case	ns_t_ptr:
	    printf( "    \"%s\"\n", dnsP->dn_ansP );
	    break;

	case	ns_t_mx:
	    printf( "    pri=%d  \"%s\"\n",
		     dnsP->dn_val1,
		     dnsP->dn_ansP );
	    break;

	default:
	    printf( "    <dunno how to print this>\n" );
	    break;
    }
}
