/* mml-dns.h -- definitions for the mml "dns" module

	Copyright 2003,2004,2005,2006,2007
		by Mark E. Mallett, MV Communications, Inc.

	See the "LICENSE" file for terms.

Provides some rudimentary functions to interface to DNS resolver
routines.

Includes various system headers.

*/


#ifndef	H_MML_DNS		/* For multiple inclusions */
#define	H_MML_DNS

#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/nameser.h>
#include <resolv.h>

    /* Define this if you want lots of junk
       in the query type translation table.
    */
/*
#define	MDNS_ALL_IN_TYPE_NAMES
*/

	/* Maximum number of cnames to follow when we chase cname links */
#define	MDNS_MAX_CNAME_LINKS	10


    /* Compatibility stuff if newer resolver routines aren't present */
#ifndef	MML_HAVE_RES_NINIT		/* from mml-autoconf.h */
  typedef struct __res_state *res_state;

#  define	res_ninit(statp) res_init()

#  define	res_nquery(statp, name, class, type, answer, anslen) \
		    res_query(name, class, type, answer, anslen)

#  define	res_nclose(statp) res_close()

#endif	/* MML_HAVE_RES_NINIT */


    /* Handle for DNS query functions */
typedef struct {
    res_state	dn_statP;		/* resolver state (coallocated) */
    UBYTE	*dn_rbufP;		/* Response buffer */
    int		dn_rbufL;		/* Allocated size of dn_rbufP */
    HEADER	*dn_rhdrP;		/* Response header (a view of dn_rbufP) */
    UBYTE	dn_nbuf[NS_MAXDNAME];	/* Name/value buffer */
    UBYTE	*dn_reP;		/* End ptr used in expansion */
    UBYTE	*dn_rP;			/* Ptr used in expansion */
    UBYTE	*dn_rfP;		/* Ptr to first result block */
    int		dn_ansC;		/* Number of answers */
    int		dn_ansX;		/* Index to next result */

# ifdef	MML_PTHREADS
    pthread_mutex_t dn_applock;		/* A lock for application use */
# endif	/* MML_PTHREADS */

	/* Caller gets to access this stuff.. */
    int		dn_ansL;		/* Length of current answer */
    UBYTE	*dn_ansP;		/* Ptr to answer name/value body */
    in_addr_t	dn_ipaddr;		/* Any IP(v4) address, network byte order */
    int		dn_val1;		/* Any per-type value. */
    ns_type	dn_anstype;		/* Type of answer */
}  MML_DNS;



/* Declarations for functions contained in this module: */

    /* Reset to the first answer */
BOOL	mdns_ans_first PROTO( (MML_DNS *dnsP) );

    /* Skip to the next answer */
BOOL	mdns_ans_next PROTO( (MML_DNS *dnsP) );

    /* Release an access handle */
void	mdns_free PROTO( (MML_DNS *dnsP) );

    /* Convert byte (octet) array to IP address in network byte order */
in_addr_t mdns_ip4_batoip PROTO( (UBYTE *oP) );

    /* Convert IP(v4) address in network byte order to byte (octet) array */
void	mdns_ip4_iptoba PROTO( (in_addr_t addr, UBYTE *oP) );

    /* Lock access to an MML_DNS struct (and possibly all of mml-dns) */
void	mdns_lock PROTO( (MML_DNS *dnsP) );

    /* Get an access handle for DNS query */
MML_DNS	*mdns_new PROTO( (void) );

    /* Make a DNS query */
BOOL	mdns_query PROTO( (MML_DNS *dnsP, char *queryP,
			   ns_class qclass, ns_type type) );

    /* Make a DNS query, following CNAMEs */
BOOL	mdns_query_canon PROTO( (MML_DNS *dnsP, char *queryP,
				 ns_class qclass, ns_type type,
				 int cmax ) );

    /* Get query type from string representation */
int	mdns_query_type_str PROTO( (ns_class qclass, char *nameP) );

    /* Release lock on an MML_DNS struct (and possibly all of mml-dns) */
void	mdns_unlock PROTO( (MML_DNS *dnsP) );

#endif	/* H_MML_DNS */
