/* wmtest.c -- tests for wildcard matching

	Copyright 2005,2006
		by Mark E. Mallett, MV Communications, Inc.

	See the "LICENSE" file for terms.

*/

#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <time.h>

#include <mml/mml.h>

#include <mml/mml-alloc.h>
#include <mml-ll.h>
#include <mml/mml-str.h>

/* Local definitions */



/* External data referenced */

extern	char	*optarg;		/* getopt() argument */
extern	int	optind;			/* getopt() index */

/* External routines used */



/* Local data publicly available */



/* Local routines and forward references */

	void	wmtest PROTO( (UBYTE *patP, UBYTE *strP, UWORD mflags) );
static	void	usage();

/* Private data */

static	BOOL	Mflags = 0;

    /* Test string(s) */
static	UBYTE	*s1P = "Re: [one] [two] buckle my shoe";

    /* pattern/string test table */
static struct {
    UBYTE	*tt_patP;	/* Pattern */
    UBYTE	**tt_strPP;	/* String */
}  Testtbl[] = {

{	"*[*]?[*]*",		&s1P				},

{	NULL, NULL }
};



main( argc, argv )
  int argc;
  char **argv;
{
	char		usageOK;
	int		optch;
	int		ttN;

    while ( usageOK &&
	   ( optch = getopt( argc, argv, "i" ) ) != EOF ) {
	switch ( optch ) {
	    case	'i':		/* Ignore case */
		Mflags |= MF_IGNCASE;
		break;

	    default:
		usageOK = FALSE;
		break;
	}
    }

    if ( !usageOK ) {
	usage();
	exit( 1 );
    }


    for ( ttN = 0; Testtbl[ttN].tt_patP != NULL; ++ttN ) {
	wmtest( Testtbl[ttN].tt_patP,
	        *Testtbl[ttN].tt_strPP,
		Mflags );
    }

    return(0);
}
/*

*//* usage()

	Print usage message

Accepts :

Returns :

*/

static void
usage()
{
    printf( "usage: wmtest [flags]\n" );
    printf( "    Flags are:\n" );
    printf( "       -i               Ignore case\n" );
    printf( "\n" );
}
/*

*//* wmtest( patP, strP, mflags )

	Perform a single string match test

Accepts :

	patP		Ptr to pattern string
	strP		Ptr to string to find the pattern in
	mflags		MF_xxx match flagbits


Returns :

	<nothing>

Notes :

*/

void
wmtest ARGLIST( (patP, strP, mflags) )
   NFARG( UBYTE		*patP )		/* Pattern */
   NFARG( UBYTE		*strP )		/* String */
    FARG( UWORD		mflags )	/* Match flags */
{
	int		smN;		/* Submatch number */
	int		smL;		/* Submatch string length */
	UBYTE		*smP;		/* Submatch string */

    printf( "wmtest:\n" );
    printf( "  pattern=\"%s\"\n", (char *)patP );
    printf( "  string =\"%s\"\n", (char *)strP );

    if ( !strmatch_wild( NULL, patP, strP, mflags ) ) {
	printf( "  no match.\n" );
    }
    else {
        printf( "  matched.\n" );
	for ( smN = 0; ; ++smN ) {
	    if ( ( smP = strmatched_part( smN, &smL ) ) == NULL )
		break;
	    printf( "  %2d: \"%s\"\n", smN, (char *)smP );
	}
    }
    printf( "\n" );
}
